from bpy.types import Context, Object
from ....libs.functions.get_common_vars import get_common_vars
from ....addon.naming import FluidLabNaming


def props_update_colliders(self, context:Context, call_from:str) -> None:

    """ Update Colliders Properties """
    
    fluid_colliders = get_common_vars(context, get_fluid_colliders=True)
    # active_collider = fluid_colliders.active

    # Cada vez que cambiamos cualquier property rebobinamos al inicio:
    # if context.scene.frame_current != context.scene.frame_start:
    #     context.scene.frame_set(context.scene.frame_start)

    all_colliders_obs = fluid_colliders.get_current_colliders
    
    for collider_ob in all_colliders_obs:
        coll_mod = collider_ob.modifiers.get(FluidLabNaming.COLLISION_MOD)
        if not coll_mod:
            continue
            
        settings = coll_mod.settings
        current_value = getattr(settings, call_from)

        # sólo si el nuevo valor es distinto:
        new_value = getattr(self, call_from)
        if current_value != new_value:
            setattr(settings, call_from, getattr(self, call_from))